<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$message = '';
$message_type = '';

// Get user ID from URL
$user_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($user_id > 0) {
    try {
        $conn = getAdminDBConnection();

        // Check if this is the main admin account
        $stmt_check = $conn->prepare("SELECT username, email FROM users WHERE id = ?");
        if ($stmt_check === false) {
            throw new Exception('Prepare check statement failed: ' . $conn->error);
        }
        $stmt_check->bind_param('i', $user_id);
        $stmt_check->execute();
        $stmt_check->bind_result($username, $email);
        $stmt_check->fetch();
        $stmt_check->close();

        if ($username === 'admin' && $email === 'admin@admin.com') {
            $message = 'لا يمكن حذف الحساب الرئيسي للأدمن.';
            $message_type = 'danger';
        } else {
            // Prepare a delete statement
            $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
            if ($stmt === false) {
                throw new Exception('Prepare delete statement failed: ' . $conn->error);
            }

            $stmt->bind_param('i', $user_id);

            if ($stmt->execute()) {
                if ($stmt->affected_rows > 0) {
                    $message = 'تم حذف المستخدم بنجاح!';
                    $message_type = 'success';
                } else {
                    $message = 'المستخدم المطلوب غير موجود أو تم حذفه مسبقًا.';
                    $message_type = 'warning';
                }
            } else {
                $message = 'حدث خطأ أثناء حذف المستخدم: ' . $conn->error;
                $message_type = 'danger';
            }
            $stmt->close();
        }
    } catch (Exception $e) {
        $message = 'خطأ: ' . $e->getMessage();
        $message_type = 'danger';
    }
} else {
    $message = 'معرف المستخدم غير صالح للحذف.';
    $message_type = 'danger';
}

// Redirect back to admin_users.php with a message
header('Location: admin_users.php?message=' . urlencode($message) . '&type=' . $message_type);
exit();
?>

<div class="container bg-dark text-white mt-5">
</div> 